function GraphFoncOnd(CoordSph,psi,rho,varargin)

% Olivier Pujol : septembre 2013

%% Reprsentation graphique (plan XOZ, phi fix (par dfaut phi=0 [pi])

%% Paramtre utile : le rayon de Bohr

aB = 0.0529177E-9;  % Rayon de Bohr (m)

%% Traitement des variables optionnelles (varargin)

if (length(varargin)>2),error('Mauvais nombre d''arguments d''entre optionnels');end

switch length(varargin)
    case 0
        angpol=0;
        raB=1;
    case 1
        angpol=varargin{1};
        raB=1;
    case 2
        angpol=varargin{1};
        raB=varargin{2};
end

%%

angpol=angpol*pi/180;
[val,Ind] = min(abs(CoordSph{3}-angpol));
[val2,Ind2] = min(abs(CoordSph{3}-(angpol+pi)));
clear val val2

[r,theta,phi]=meshgrid(CoordSph{1},CoordSph{2},CoordSph{3});

[x,y,z]=sph2cart(phi,pi/2-theta,r);

clear r theta phi

figure
pcolor(cat(1,x(:,:,Ind),-x(:,:,Ind)), ...
    cat(1,z(:,:,Ind),z(:,:,Ind)), ...
    cat(1,real(psi(:,:,Ind)),real(psi(:,:,Ind2)))*aB^1.5);
shading interp
axis square
colormap(jet)
colorbar('vertical')
xlabel('\itX','Fontsize',16);
ylabel('\itZ','Fontsize',16);
title(['Re\{\Psi\} * a_B^{3/2} dans le plan phi = ',num2str(CoordSph{3}(Ind)*180/pi),' [\pi]'],'Fontsize',16);

figure
pcolor(cat(1,x(:,:,Ind),-x(:,:,Ind)), ...
    cat(1,z(:,:,Ind),z(:,:,Ind)), ...
    cat(1,rho(:,:,Ind),rho(:,:,Ind2))*aB^3);
shading interp
axis square
colormap(jet)
colorbar('vertical')
xlabel('\itX','Fontsize',16);
ylabel('\itZ','Fontsize',16);
title(['|\Psi|^2 * a_B^3 dans le plan phi = ',num2str(CoordSph{3}(Ind)*180/pi),' [\pi]'],'Fontsize',16);

clear Ind Ind2

 [val,Ind]=min(abs(CoordSph{1}-raB));
 clear val
 
 figure;
 xp=squeeze(x(:,Ind,:)).*squeeze(abs(real(psi(:,Ind,:)))*aB^1.5);
 yp=squeeze(y(:,Ind,:)).*squeeze(abs(real(psi(:,Ind,:)))*aB^1.5);
 zp=squeeze(z(:,Ind,:)).*squeeze(abs(real(psi(:,Ind,:)))*aB^1.5);

 surf(xp,yp,zp,squeeze(real(psi(:,Ind,:)))*aB^1.5);
 shading interp;
 colormap(jet);
 colorbar('vertical');
 axis equal;
 title(['Re\{\Psi\} * a_B^{1.5} pour r/a_B = ',num2str(CoordSph{1}(Ind)),''],'Fontsize',16);
 xlabel('\itX','Fontsize',16);
 ylabel('\itY','Fontsize',16);
 zlabel('\itZ','Fontsize',16);
 axis tight;

 clear xp yp zp
 
 figure;
 xr=squeeze(x(:,Ind,:)).*squeeze(rho(:,Ind,:)*aB^3);
 yr=squeeze(y(:,Ind,:)).*squeeze(rho(:,Ind,:)*aB^3);
 zr=squeeze(z(:,Ind,:)).*squeeze(rho(:,Ind,:)*aB^3);

 surf(xr,yr,zr,squeeze(rho(:,Ind,:)*aB^3));
 shading interp;
 colormap(jet);
 colorbar('vertical');
 axis equal;
 title(['|\Psi|^2 * a_B^3 pour r/a_B = ',num2str(CoordSph{1}(Ind)),''],'Fontsize',16);
 xlabel('\itX','Fontsize',16);
 ylabel('\itY','Fontsize',16);
 zlabel('\itZ','Fontsize',16);
 axis tight;
 
 clear xr yr zr
 
return;